% file for iteration algorithm, optimzation problem P1
function [obj2,gamma1,K,S] = Optimization_P2(A,B,F,D,C,Mc,Nc,alpha1,alpha2,Rk) 

[n,m] = size(B);
[~,q] = size(F);
[~,l] = size(D);
[p,~] = size(C);

Cx = eye(n);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
gamma10 = sdpvar(1);
X10 = sdpvar(m,n);
P10 = sdpvar(n,n);

LMI1 = blkvar();
LMI1(1,1) = (A*P10 + B*X10) + (A*P10 + B*X10)';
LMI1(1,2) = D;
LMI1(1,3) = Mc;
LMI1(1,4) = P10*Nc';
LMI1(1,5) = P10*Cx';

LMI1(2,2) = -gamma10*eye(l);

LMI1(3,3) = -eye(n);

LMI1(4,4) = -eye(n);

LMI1(5,5) = -gamma10*eye(n);

LMI1 = sdpvar(LMI1);

%%%%%%%LMI2
S0 = sdpvar(n,n);

LMI2 = blkvar();
LMI2(1,1) = (A*P10 + B*X10) + (A*P10 + B*X10)';
LMI2(1,2) = B;
LMI2(1,3) = Mc;
LMI2(1,4) = P10*Nc';
LMI2(1,5) = P10;

LMI2(2,2) = -inv(Rk);

LMI2(3,3) = -eye(n);
LMI2(4,4) = -eye(n);
LMI2(5,5) = -S0;

LMI2 = sdpvar(LMI2);


%%%%%%%%%%%%%%%%%%
const = [];
obj = alpha1*gamma10 + alpha2*trace(S0);

const = [const, P10 >= eps*eye(n)];
const = [const, gamma10 >= eps];
const = [const, LMI1 <= -eps*eye(4*n+l)];

const = [const, S0 >= eps*eye(n)];
const = [const, LMI2 <= -eps*eye(4*n+m)];

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%5
ops = sdpsettings('solver','mosek','verbose',0);
optimize(const,1.0e-6*obj,ops);

K =  value(X10)*inv(value(P10));
gamma1 = value(gamma10);
S = value(S0);
obj2 = 1.0e-6*value(obj);
